%Liam Farrar
%24/02/2018

clear all;
close all;

%File details
    delimiterIn = ' ';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end
   
%Open the datafile
    FilterSpec = '.dat';

    DialogTitle = 'Select file with H/R data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);
   
%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end
    
    Hcol = Data(:,1);
    Rcol = Data(:,2);
    
%Split into pos and neg fields  
    n = size(Hcol);
    j = 1;
    k = 1;
    
    for i = 1:n
        if Hcol(i) > 0
            Hcol_pos(j,1) = Hcol(i);
            Rcol_pos(j,1) = Rcol(i);
            j = j + 1;
        else
        end
        if Hcol(i) < 0    
            Hcol_neg(k,1) = Hcol(i);
            Rcol_neg(k,1) = Rcol(i);
            k = k + 1;
        else
        end
    end
    
    if Data(1,1) <= 0
    
%Double pos field
    n = size(Hcol_pos,1);
    j = 0;
          
    for i = 1:n
        Hcol_posd(i,1) = Hcol_pos(i,1);
        Rcol_posd(i,1) = Rcol_pos(i,1);
        Hcol_posd(i+n,1) = Hcol_pos(n-j,1);
        Rcol_posd(i+n,1) = Rcol_pos(n-j,1);
        j = j + 1;
    end
    
%Double neg field        
    n = size(Hcol_neg,1);
    j = 0;
        
    for i = 1:n
        Hcol_negd(i,1) = Hcol_neg(n-j,1);
        Rcol_negd(i,1) = Rcol_neg(n-j,1);
        Hcol_negd(i+n,1) = Hcol_neg(i,1);
        Rcol_negd(i+n,1) = Rcol_neg(i,1);
        j = j + 1;
    end
    
    else 
%~~~~~~~~~~~~~~~~~~~~~~~~~~#
%Double pos field
    n = size(Hcol_pos,1);
    j = 0;
          
    for i = 1:n
        Hcol_posd(i,1) = Hcol_pos(n-j,1);
        Rcol_posd(i,1) = Rcol_pos(n-j,1);
        Hcol_posd(i+n,1) = Hcol_pos(i,1);
        Rcol_posd(i+n,1) = Rcol_pos(i,1);
        j = j + 1;
    end
    
%Double neg field        
    n = size(Hcol_neg,1);
    j = 0;
        
    for i = 1:n
        Hcol_negd(i,1) = Hcol_neg(i,1);
        Rcol_negd(i,1) = Rcol_neg(i,1);
        Hcol_negd(i+n,1) = Hcol_neg(n-j,1);
        Rcol_negd(i+n,1) = Rcol_neg(n-j,1);
        j = j + 1;
    end    
    end
      
%Combine all results
    Hcol = cat(1, Hcol_posd, Hcol_negd);
    Rcol = cat(1, Rcol_posd, Rcol_negd);
    Data_Save(:,1) = Hcol(:);
    Data_Save(:,2) = Rcol(:);
    
%Save data into files
    save('Save/110_Degree_LF8.dat','Data_Save','-ascii');
  

    
